/*
 * XXXX 
 *
 * Fecha 08/05/2007
 * 
 *  
 */
 
package com.ejie.p06b.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.ejie.p06b.exception.P06BException;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BErrores;
import com.ejie.p06b.general.P06BPaginas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFieldsValidations;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;

/**
 *  Esta clase representa una clase base para la implementacin de servlets
 *  para la gestin de las pantallas de la aplicacin.
 *  Incluye una serie de mtodos comunes a todos los servlets de manejo
 *  de pantallas.
 */
public class P06BServlet extends HttpServlet {
    
    // Contexto del servlet
    private ServletContext servCtx;
    
    //Control de sesion
    protected static final String sessionFlag = "QWght1YUhJ_T2Tfr-3TTjuJ4Jk55mnP6_v7pl8kj9y0ssY0_wwYG";
    protected static final String nameSessionFlag    = "__NAMESESSIONFLAG__";
    
    
    /**
     *  Inicializa variables globales.
     *  @param  config  variables globales a inicializar.
     *  @throws ServletException
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        servCtx = config.getServletContext();
    }
    
    /**
     *  Representa la operacin de peticin HTTP get
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
    {}
    
    /**
     *  Representa la operacin de peticin HTTP post
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
    {}
    
    /**
     *  verifica que la sesion es correcta
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @return si hay o no error
     *  @throws ServletException
     *  @throws IOException
     */
    protected boolean verificarSesion(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession();
        if (session==null) {
        	P06BLog.send(0,this.getClass().getName(), "No se recibe la sesion");
            return true;
        }
        else {
            String auxiliar = (String)session.getAttribute(nameSessionFlag);
            
            if (auxiliar==null) {
            	P06BLog.send(0,this.getClass().getName(), "No hay nameSessionFlag");
                return true;
            }
            else if (!auxiliar.equals(sessionFlag)) {
            	P06BLog.send(0,this.getClass().getName(), "No hay SessionFlag");
                return true;
            }
        }
        return false;
    }
    
    /**
     *  marca la sesion
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    protected void marcarSesion(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        session.setAttribute(nameSessionFlag, sessionFlag);
    }
    
    /**
     *  Trata los errores de seguridad que pudiesen haber surgido en el servlet envindolos
     *  a una pgina de errores.
     *  @param  request     Peticion del cliente
     *  @param  response    Respuesta al cliente
     *  @param  e           Excepcin que se va a tratar.
     */
    protected void manejarErrorSesion(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(P06BPaginas.P06B_JSP_PAGINA_ERROR_SESSION);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    public String getServletInfo() {
        return "Servlet genrico P06BServlet";
    }
    
    /**
     *  Trata los errores que pudiesen haber surgido en el servlet envindolos
     *  a una pgina de errores.
     *  @param  request     Peticion del cliente
     *  @param  response    Respuesta al cliente
     *  @param  e           Excepcin que se va a tratar.
     */
    protected void manejarErrores(HttpServletRequest request, HttpServletResponse response, Exception e) {
        try {
            String params="";
        	if(e instanceof P06BException){
            	//Pasamos la excepcin a una pgina jsp
            	request.setAttribute(P06BConstantes.P06B_VAR_DESC_ERROR, ((P06BException)e).getCodigo());
            	params="?"+P06BConstantes.P06B_VAR_DESC_ERROR+"="+((P06BException)e).getCodigo();
        	}else{	
	        	// Pasamos la excepcin a una pgina jsp
	            request.setAttribute(P06BConstantes.P06B_VAR_DESC_ERROR, e.getMessage());
	            params="?"+P06BConstantes.P06B_VAR_DESC_ERROR+"="+(e.toString() + " - " + e.getMessage());
        	}  
            P06BLog.send(0,this.getClass().getName(), "Excepcion: " + e);
            P06BLog.send(0,this.getClass().getName(), "Cargando pagina de error: " + P06BPaginas.P06B_JSP_PAGINA_ERROR_APLICACION);
            forward (request, response, P06BPaginas.P06B_JSP_PAGINA_ERROR_APLICACION+params);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    /**
     *  Realiza una redireccin a una pgina pasada como parmetro
     *  @param  req     Peticin del cliente
     *  @param  res     Respuesta al cliente
     *  @param  page    Nombre de pgina a la que queremos redireccionar.
     */
    public void forward(HttpServletRequest req, HttpServletResponse res, String page) {
        try {
            P06BLog.send(0,this.getClass().getName(), "Cargando pagina: " + page);
            //getServletConfig ().getServletContext().getRequestDispatcher(page).forward(req, res);
            RequestDispatcher rd = servCtx.getRequestDispatcher(page);
            rd.forward(req, res);
        }
        catch (Exception ex) {
            manejarErrores(req, res, ex);
        }
    }
    
    /**
     *  Introduce un objeto en la sesin.
     *  @param  clave   nombre del objeto para referenciarlo en la sesin.
     *  @param  objeto  objeto que queremos introducir en la sesin.
     *  @param  request Peticin del cliente.
     *  @param  response Respuesta al cliente.
     */
    protected void setObjetoSesion(String clave, Object objeto, HttpServletRequest request,
    HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            session.setAttribute(clave, objeto);
        }
        catch (Exception e) {
            manejarErrores(request, response, e);
        }
    }
    
    /**
     *  Obtiene de la sesin un determinado objeto.
     *  @param  clave   nombre con el que referenciamos al objeto de la sesin
     *                  que queremos obtener.
     *  @param  request Peticin del cliente.
     *  @param  response  Respuesta al cliente.
     */
    protected Object getObjetoSesion(String clave, HttpServletRequest request,
    HttpServletResponse response) {
        Object obj = null;
        try {
            HttpSession session = request.getSession();
            obj = session.getAttribute(clave);
        }
        catch (Exception e) {
            manejarErrores(request, response, e);
        }
        return obj;
    }
    
    /**
     *  Trata los errores de seguridad que pudiesen haber surgido en el servlet envindolos
     *  a una pgina de errores.
     *  @param  request     Peticion del cliente
     *  @param  response    Respuesta al cliente
     *  @param  e           Excepcin que se va a tratar.
     */
    protected void manejarErrorSeguridad(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(P06BPaginas.P06B_JSP_PAGINA_ERROR_SEGURIDAD);
        }
        catch (Exception ex) {
            P06BLog.send(0,this.getClass().getName(), "Excepcion: " + ex);
        }
    }

    protected void setNoCache(HttpServletResponse res) {
        res.setHeader("pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Cache-Control", "max-age=3D10");
        res.setHeader("Expires", "0");
    }
    
    /**
     *  Representa la validacin de los parmetros que llegan de la request
     *  @param  request     Peticin del cliente
     *  @throws P06BException
     */
    public void fieldsValidations(HttpServletRequest request, String idioma)
    throws P06BException{
    	try{
    		ArrayList errors = new ArrayList();
    		StringTokenizer st = new StringTokenizer(request.getParameter("fieldsValidations"),"|");
    		StringTokenizer st2 = null;
    		StringTokenizer st3 = null;
    		String bloqueCampo = "";
    		String tipo = "";
    		String campo = "";
    		String nombreCampo = "";
    		while ( st.hasMoreTokens() ){
    			bloqueCampo = st.nextToken();
    			st2 = new StringTokenizer(bloqueCampo,"#");
    			campo=st2.nextToken();
    			nombreCampo=st2.nextToken();
    			st3 = new StringTokenizer(st2.nextToken(),",");
    			while ( st3.hasMoreTokens() ){
    				tipo = st3.nextToken();
    				//Con la informacin obtenida realizo las validaciones
    				errors=P06BFieldsValidations.validation(errors,tipo,nombreCampo,request.getParameter(campo),idioma);
    			}
    		}
    		request.setAttribute("errors",errors);
    	}catch(Exception e){
    		P06BLog.send(1,this.getClass().toString(), e.getMessage());
    		throw new P06BException(e,P06BErrores.P06B_ERROR_0003);
    	}
    }
   
    public String getIdioma(HttpServletRequest req,HttpServletResponse res) {
    	P06BPerfilUsuario lPerfil = (P06BPerfilUsuario) getObjetoSesion (P06BConstantes.P06B_VAR_PERFIL_USUARIO,req,res);
    	return lPerfil.getIdIdioma();
    }
    
    public P06BPerfilUsuario getP06BPerfilUsuario(HttpServletRequest req,HttpServletResponse res) {
    	P06BPerfilUsuario lPerfil = (P06BPerfilUsuario) getObjetoSesion (P06BConstantes.P06B_VAR_PERFIL_USUARIO,req,res);
    	return lPerfil;
    }

    /**
     * 
     * Mtodo que se utiliza para gestionar en la aplicacin el uso de la sesin por parte
     * de la aplicacin.
     * 
     * Recorre todas las variables de sesin identificando las temporales (a partir de una constante)
     * y las elimina de la misma si corresponde.
     * 
     * */
    public void deleteAllTempFromSession(HttpServletRequest req) {
    	req.getSession().getAttributeNames();
    	Enumeration ite = req.getSession().getAttributeNames();
        while (ite.hasMoreElements ()) {
            String atributteName = (String)ite.nextElement();
            if(atributteName.indexOf(P06BConstantes.P06B_VAR_TEMP)!=-1){
            	req.getSession().removeAttribute(atributteName);
            }
        }

    }
    
    /**
     * 
     * Mtodo que se utiliza para gestionar en la aplicacin el uso de la sesin por parte
     * de la aplicacin.
     * 
     * Se pasa un parmetro que define aquella excepcion dentro de las variables de sesin
     * que no ser borrada. Se utilizar mucho para los filtros.
     * 
     * Recorre todas las variables de sesin identificando las temporales (a partir de una constante)
     * y las elimina de la misma si corresponde.
     * 
     * */
    public void deleteTempFromSession(HttpServletRequest req, String excepcion) {
    	req.getSession().getAttributeNames();
    	Enumeration ite = req.getSession().getAttributeNames();
        while (ite.hasMoreElements ()) {
            String atributteName = (String)ite.nextElement();
            if(atributteName.indexOf(P06BConstantes.P06B_VAR_TEMP)!=-1 && atributteName.indexOf(excepcion)==-1){
            	req.getSession().removeAttribute(atributteName);
            }
        }

    }
}
